/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.pngwalk;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.text.ParseException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.autoplot.pngwalk.ClickDigitizer;
import org.autoplot.pngwalk.PngWalkTool;
import org.autoplot.pngwalk.PngWalkView;
import org.autoplot.pngwalk.WalkImageSequence;
import org.das2.qds.QDataSet;

public final class SinglePngWalkView
extends PngWalkView {
    private transient BufferedImage cacheImage;
    Rectangle imageLocation = null;
    AffineTransform affineTransform = new AffineTransform();
    MouseWheelListener delegate = this.getMouseWheelListener();
    Point mousePressPoint = null;
    transient ClickDigitizer clickDigitizer = new ClickDigitizer(this);
    int clickDigitizerSelect = -1;
    long reportedExceptionTime = 0L;
    String reportedExceptionStr = "";
    private PngWalkTool viewer = null;

    public SinglePngWalkView(WalkImageSequence s) {
        this(s, null);
    }

    public SinglePngWalkView(WalkImageSequence s, final PngWalkTool viewer) {
        super(s);
        this.setShowCaptions(true);
        this.addMouseWheelListener(e -> {
            if ((e.getModifiersEx() & 0x80) == 128) {
                this.affineTransform.scale(1.0 - 0.04 * (double)e.getWheelRotation(), 1.0 - 0.04 * (double)e.getWheelRotation());
                this.repaint();
            } else {
                this.delegate.mouseWheelMoved(e);
            }
        });
        MouseAdapter ma = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                MouseAdapter ma;
                if (e.isPopupTrigger()) {
                    JPopupMenu m = SinglePngWalkView.this.getPopup();
                    m.add(new JMenuItem(new AbstractAction("Reset Zoom (Ctrl+MouseWheel to set)"){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            SinglePngWalkView.this.affineTransform = new AffineTransform();
                            SinglePngWalkView.this.repaint();
                        }
                    }));
                    m.show(e.getComponent(), e.getX(), e.getY());
                    return;
                }
                SinglePngWalkView.this.mousePressPoint = e.getPoint();
                Point p = SinglePngWalkView.this.getImagePosition(e.getX(), e.getY());
                MouseAdapter mouseAdapter = ma = viewer != null ? viewer.getImageMouseAdapter() : null;
                if (ma != null) {
                    MouseEvent ep = new MouseEvent(e.getComponent(), e.getID(), e.getWhen(), e.getModifiers(), p.x, p.y, e.getClickCount(), e.isPopupTrigger(), e.getButton());
                    ep.setSource(SinglePngWalkView.this);
                    ma.mousePressed(ep);
                    SinglePngWalkView.this.repaint();
                    return;
                }
                if ((e.getModifiersEx() & 0x80) == 128) {
                    return;
                }
                if (e.getButton() != 1) {
                    return;
                }
                if (p != null) {
                    try {
                        SinglePngWalkView.this.clickDigitizerSelect = SinglePngWalkView.this.clickDigitizer.maybeSelect(p);
                    }
                    catch (IOException | ParseException ex) {
                        Logger.getLogger(SinglePngWalkView.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
                if (SinglePngWalkView.this.clickDigitizerSelect == -1) {
                    BufferedImage i;
                    Rectangle lrect = SinglePngWalkView.this.imageLocation;
                    if (SinglePngWalkView.this.imageLocation == null) {
                        return;
                    }
                    Point2D clickPos = new Point2D.Double(e.getX(), e.getY());
                    if (!SinglePngWalkView.this.affineTransform.isIdentity()) {
                        try {
                            clickPos = SinglePngWalkView.this.affineTransform.inverseTransform(clickPos, null);
                        }
                        catch (NoninvertibleTransformException ex) {
                            Logger.getLogger(SinglePngWalkView.class.getName()).log(Level.SEVERE, null, ex);
                        }
                    }
                    if ((i = SinglePngWalkView.this.seq.currentImage().getImage()) == null) {
                        return;
                    }
                    double factor = lrect.getWidth() / (double)i.getWidth(null);
                    int imageX = (int)((clickPos.getX() - (double)lrect.x) / factor);
                    int imageY = (int)((clickPos.getY() - (double)lrect.y) / factor);
                    try {
                        SinglePngWalkView.this.clickDigitizer.doLookupMetadata(imageX, imageY, false);
                    }
                    catch (IOException | ParseException ex) {
                        Logger.getLogger(SinglePngWalkView.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                MouseAdapter ma;
                super.mouseReleased(e);
                if (e.isPopupTrigger()) {
                    JPopupMenu m = SinglePngWalkView.this.getPopup();
                    m.add(new JMenuItem(new AbstractAction("Reset Zoom (Ctrl+MouseWheel to set)"){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            SinglePngWalkView.this.affineTransform = new AffineTransform();
                            SinglePngWalkView.this.repaint();
                        }
                    }));
                    m.show(e.getComponent(), e.getX(), e.getY());
                    return;
                }
                Point p = SinglePngWalkView.this.getImagePosition(e.getX(), e.getY());
                MouseAdapter mouseAdapter = ma = viewer != null ? viewer.getImageMouseAdapter() : null;
                if (ma != null) {
                    MouseEvent ep = new MouseEvent(e.getComponent(), e.getID(), e.getWhen(), e.getModifiers(), p.x, p.y, e.getClickCount(), e.isPopupTrigger(), e.getButton());
                    ep.setSource(SinglePngWalkView.this);
                    ma.mouseReleased(ep);
                    SinglePngWalkView.this.repaint();
                    return;
                }
                if (e.getButton() != 1) {
                    return;
                }
                if (SinglePngWalkView.this.clickDigitizerSelect == -1) {
                    BufferedImage i;
                    Rectangle lrect = SinglePngWalkView.this.imageLocation;
                    if (SinglePngWalkView.this.imageLocation == null) {
                        return;
                    }
                    Point2D clickPos = new Point2D.Double(e.getX(), e.getY());
                    if (!SinglePngWalkView.this.affineTransform.isIdentity()) {
                        try {
                            clickPos = SinglePngWalkView.this.affineTransform.inverseTransform(clickPos, null);
                        }
                        catch (NoninvertibleTransformException ex) {
                            Logger.getLogger(SinglePngWalkView.class.getName()).log(Level.SEVERE, null, ex);
                        }
                    }
                    if ((i = SinglePngWalkView.this.seq.currentImage().getImage()) == null) {
                        return;
                    }
                    double factor = lrect.getWidth() / (double)i.getWidth(null);
                    int imageX = (int)((clickPos.getX() - (double)lrect.x) / factor);
                    int imageY = (int)((clickPos.getY() - (double)lrect.y) / factor);
                    try {
                        SinglePngWalkView.this.clickDigitizer.doLookupMetadata(imageX, imageY, true);
                    }
                    catch (IOException | ParseException ex) {
                        Logger.getLogger(SinglePngWalkView.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
            }

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                MouseAdapter ma;
                Point p;
                if (SinglePngWalkView.this.mousePressPoint != null && (e.getModifiersEx() & 0x80) == 128) {
                    p = e.getPoint();
                    SinglePngWalkView.this.affineTransform.translate((double)(p.x - SinglePngWalkView.this.mousePressPoint.x) / SinglePngWalkView.this.affineTransform.getScaleX(), (double)(p.y - SinglePngWalkView.this.mousePressPoint.y) / SinglePngWalkView.this.affineTransform.getScaleY());
                    SinglePngWalkView.this.mousePressPoint = p;
                    SinglePngWalkView.this.repaint();
                }
                p = SinglePngWalkView.this.getImagePosition(e.getX(), e.getY());
                MouseAdapter mouseAdapter = ma = viewer != null ? viewer.getImageMouseAdapter() : null;
                if (ma != null) {
                    String img = SinglePngWalkView.this.seq.getSelectedName();
                    MouseEvent ep = new MouseEvent(e.getComponent(), e.getID(), e.getWhen(), e.getModifiers(), p.x, p.y, e.getClickCount(), e.isPopupTrigger(), e.getButton());
                    ep.setSource(img);
                    ma.mouseDragged(ep);
                    SinglePngWalkView.this.repaint();
                }
            }
        };
        this.addMouseListener(ma);
        this.addMouseMotionListener(ma);
        this.setPreferredSize(new Dimension(300, 300));
        this.setViewer(viewer);
    }

    public ClickDigitizer getClickDigitizer() {
        return this.clickDigitizer;
    }

    protected void setViewer(PngWalkTool viewer) {
        this.viewer = viewer;
        this.clickDigitizer.setViewer(viewer);
    }

    private Point getImagePosition(int x, int y) {
        Rectangle lrect = this.imageLocation;
        if (this.imageLocation == null) {
            return null;
        }
        BufferedImage i = this.seq.currentImage().getImage();
        if (i == null) {
            return null;
        }
        double factor = lrect.getWidth() / (double)i.getWidth(null);
        int imageX = (int)((double)(x - lrect.x) / factor);
        int imageY = (int)((double)(y - lrect.y) / factor);
        return new Point(imageX, imageY);
    }

    @Override
    protected void paintComponent(Graphics g1) {
        int w;
        super.paintComponent(g1);
        Graphics2D g2 = (Graphics2D)g1;
        AffineTransform at = g2.getTransform();
        at.concatenate(this.affineTransform);
        g2.setTransform(at);
        g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (this.seq == null || this.seq.size() == 0) {
            return;
        }
        for (int i = 0; i < this.seq.size(); ++i) {
            this.seq.imageAt(i).removeObserver(this);
        }
        BufferedImage i = this.seq.currentImage().getImage();
        this.seq.currentImage().addObserver(this);
        long ageMillis = System.currentTimeMillis() - this.seq.currentImage().getInitLoadBirthTime();
        if (i != null && i.getWidth(this) > 0 && i.getHeight(this) > 0) {
            this.imageLocation = this.paintImageCentered(i, g2, this.seq.currentImage().getCaption());
            this.cacheImage = i;
        } else {
            if (this.cacheImage != null) {
                this.imageLocation = this.paintImageCentered(this.cacheImage, g2, this.seq.currentImage().getCaption());
            }
            if (ageMillis > 100L) {
                this.paintImageCentered(loadingImage, g2);
            } else {
                this.repaint(150L);
            }
        }
        if (i != null && this.clickDigitizer.viewer != null && this.clickDigitizer.viewer.digitizer != null) {
            int h = i.getHeight();
            w = i.getWidth();
            try {
                QDataSet ids = this.clickDigitizer.doTransform();
                if (ids != null) {
                    block8: for (int j = 0; j < ids.length(); ++j) {
                        QDataSet ids1 = ids.rank() == 2 ? ids.slice(j) : ids;
                        int ix = (int)ids1.value(0);
                        int iy = (int)ids1.value(1);
                        if (ix < 0 || iy < 0 || ix >= w || iy >= h) continue;
                        Rectangle lrect = this.imageLocation;
                        if (this.imageLocation == null) {
                            return;
                        }
                        double factor = lrect.getWidth() / (double)w;
                        int imageX = (int)((double)ix * factor + (double)lrect.x);
                        int imageY = (int)((double)iy * factor + (double)lrect.y);
                        switch (this.clickDigitizer.viewer.annoTypeChar) {
                            case '+': {
                                g2.setColor(Color.LIGHT_GRAY);
                                g2.drawLine(0, imageY, this.getWidth(), imageY);
                                g2.drawLine(imageX, 0, imageX, this.getHeight());
                                Color c0 = g2.getColor();
                                Stroke stroke0 = g2.getStroke();
                                g2.setColor(g2.getBackground());
                                g2.setStroke(new BasicStroke(1.0f, 2, 0, 1.0f, new float[]{1.0f, 3.0f}, 0.0f));
                                g2.drawLine(0, imageY, this.getWidth(), imageY);
                                g2.drawLine(imageX, 0, imageX, this.getHeight());
                                g2.setColor(Color.BLACK);
                                g2.drawLine(imageX - 20, imageY, imageX + 20, imageY);
                                g2.drawLine(imageX, imageY - 20, imageX, imageY + 20);
                                g2.setStroke(stroke0);
                                g2.setColor(c0);
                                continue block8;
                            }
                            case '|': {
                                g2.drawLine(imageX, 0, imageX, this.getHeight());
                                Color c0 = g2.getColor();
                                Stroke stroke0 = g2.getStroke();
                                g2.setColor(g2.getBackground());
                                g2.setStroke(new BasicStroke(1.0f, 2, 0, 1.0f, new float[]{1.0f, 3.0f}, 0.0f));
                                g2.drawLine(imageX, 0, imageX, this.getHeight());
                                g2.setStroke(stroke0);
                                g2.setColor(c0);
                                continue block8;
                            }
                            case '.': {
                                g2.drawOval(imageX - 2, imageY - 2, 5, 5);
                                Color c0 = g2.getColor();
                                g2.setColor(g2.getBackground());
                                g2.fillOval(imageX - 1, imageY - 1, 3, 3);
                                g2.setColor(c0);
                                continue block8;
                            }
                        }
                    }
                }
            }
            catch (IOException ex) {
                Logger.getLogger(SinglePngWalkView.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        if (this.viewer != null && i != null) {
            Rectangle lrect = this.imageLocation;
            if (this.imageLocation == null) {
                return;
            }
            w = i.getWidth();
            double factor = lrect.getWidth() / (double)w;
            AffineTransform at1 = AffineTransform.getTranslateInstance(lrect.x, lrect.y);
            at1.scale(factor, factor);
            g2.transform(at1);
            Color c0 = g2.getColor();
            this.viewer.decorators.forEach(p -> {
                try {
                    p.paint(g2);
                }
                catch (Exception ex) {
                    long t = System.currentTimeMillis();
                    if (t - this.reportedExceptionTime > 1000L) {
                        ByteArrayOutputStream baos = new ByteArrayOutputStream();
                        ex.printStackTrace();
                        ex.printStackTrace(new PrintStream(baos));
                        this.reportedExceptionStr = baos.toString();
                        this.reportedExceptionTime = t;
                    }
                    g2.setColor(c0);
                    g2.drawString(this.reportedExceptionStr, 0, 16);
                }
            });
        }
    }
}

